#!/bin/sh
: Make sure we get executed by sh on all systems

platform=`uname -s`;
arch=`uname -m`;
cdir=`pwd`;
fdir=`pwd`;
mupgrade="n";
nuniq="";
initservice=`ps -p1 | grep systemd | awk '{print $4}'`;

check_version () {
	kitversion=3500;
	thisversion=`cat thisversion`;
	if [ $kitversion -ne $thisversion ]; then
		echo "kit version mismatch, exiting";
		exit 1;
	fi
}

if id | grep "^uid=0(" >/dev/null 2>&1
	then # user IS superuser
        	echo "Commencing NQCSatellite configure as root.";
	else
        	echo "NQCSatellite needs to be installed as root.";
        	exit 1;
fi

if [ "$platform" = 'Darwin' ]; then 
	if [ -f /Library/LaunchDaemons/com.visualware.nqc.plist ]; then
       		echo "=========================================="
		echo "nqc unload old";
		launchctl unload /Library/LaunchDaemons/com.visualware.nqc.plist;
	fi
fi

if [ -f prevlocation ]; then
        mdir=`tail -n 1 prevlocation`;
else
	mdir=$cdir;
fi

if [ -f $mdir/nqc.sh ] && [ -f $mdir/update_nqc.sh ]; then
	echo "Do you want to perform simple upgrade (y/n)?";
	read mupgrade;
	if [ "$mupgrade" = 'y' ]; then
		if [ "$platform" = 'Darwin' ]; then 
			tar -xf $fdir/nqc.tar osxNQCSatellite;
			cp -f osxNQCSatellite $mdir/NQCSatellite;
			echo "Copy OSX executable live";
		elif [ "$platform" = 'Linux' ]; then
			if [ "$arch" = "armv6l" ]; then
				tar -xf $fdir/nqc.tar armNQCSatellite;
         			cp -f armNQCSatellite NQCSatellite;
         			echo "Copying Arm executable live";
         		elif [ "$arch" = "armv7l" ]; then
				tar -xf $fdir/nqc.tar armNQCSatellite;
         			cp -f armNQCSatellite NQCSatellite;
         			echo "Copying Arm executable live";
         		elif [ "$arch" = "armv5tel" ]; then
				tar -xf $fdir/nqc.tar armNQCSatellite;
         			cp -f armNQCSatellite NQCSatellite;
         			echo "Copying Arm executable live";
         		elif [ "$arch" = "aarch64" ]; then
				tar -xf $fdir/nqc.tar aarch64NQCSatellite;
         			cp -f aarch64NQCSatellite NQCSatellite;
         			echo "Copying Arm executable live";
         		elif [ "$arch" = "x86_64" ]; then
				tar -xf $fdir/nqc.tar x86_64NQCSatellite;
         			cp -f x86_64NQCSatellite NQCSatellite;
         			echo "Copying x86 64bit executable live";
         		else
         			echo "Please contact support for a 32 bit NQC executable";
         		fi
		fi
		rm $fdir/nqc.tar;
		if [ "$platform" = 'Darwin' ]; then 
			if [ -f /Library/LaunchDaemons/com.visualware.nqc.plist ]; then
				launchctl load /Library/LaunchDaemons/com.visualware.nqc.plist;
			fi
		else
			sh $mdir/start_nqc.sh;
		fi
		exit 0;
	fi
fi

if [ "$platform" != 'Darwin' ]; then 
	echo "Looking for old NQCAgent install, please wait...";
	find / -name NQCAgent -print > /tmp/nqcagent.$$;
	for i in `cat /tmp/nqcagent.$$`
	do
		oldbnam=`basename $i`;
		olddnam=`dirname $i`;
		echo "removing NQCAgent in $olddnam";
		cd $olddnam;
		if [ -f nqc.sh ]; then
			sh nqc.sh stop;
		fi
		if [ -x /usr/sbin/update-rc.d ]; then
        		echo "=========================================="
        		dest="/etc/init.d";
        		echo "Checking if service exists";
        		if [ -f $dest/$oldbnam ]; then
                		echo "Removing existing $oldbnam service";
                		rm /etc/init.d/$oldbnam
                		/usr/sbin/update-rc.d -f $oldbnam remove;
        		fi
		elif [ -x /sbin/chkconfig ]; then
			echo "=========================================="
			echo "Checking if service exists";
			if [ -f /etc/debian_version ]; then
				dest="/etc/init.d";
			elif [ -f /etc/SuSE-release ]; then
				dest="/etc/init.d";
			else
				dest="/etc/rc.d/init.d";
			fi
			if [ -f $dest/$oldbnam ]; then
				echo "Removing existing $oldbnam service";
				chkconfig --del $oldbnam;
			fi
		fi

		if [ -f armNQCAgent ]; then
			rm armNQCAgent;
		fi
		if [ -f console.log ]; then 
			rm console.log;
		fi
		if [ -f libArmLinuxNetQCheckAPI.a ]; then
			rm libArmLinuxNetQCheckAPI.a;
		fi
		if [ -f libLinuxNetQCheckAPI.a ]; then
			rm libLinuxNetQCheckAPI.a;
		fi
		if [ -f libPPCLinuxNetQCheckAPI.a ]; then
			rm libPPCLinuxNetQCheckAPI.a;
		fi
		if [ -f netqcheck.cfg ]; then 
			rm netqcheck.cfg;
		fi
		if [ -f NQCAgent ]; then
			rm NQCAgent;
		fi
		if [ -f nqc.sh ]; then 
			rm nqc.sh;
		fi
		if [ -f ppcNQCAgent ]; then 
			rm ppcNQCAgent;
		fi
		if [ -f redmelinux.txt ]; then 
			rm redmelinux.txt;
		fi
		if [ -f redme_install_linux.txt ]; then 
			rm redme_install_linux.txt;
		fi
		if [ -f runagent.dat ]; then 
			rm runagent.dat;
		fi
		if [ -f start_nqc.sh ]; then 
			rm start_nqc.sh;
		fi
		if [ -f stop_nqc.sh ]; then 
			rm stop_nqc.sh;
		fi
		if [ -f x86NQCAgent ]; then
			rm x86NQCAgent;
		fi
		echo " removed NQCAgent in $olddnam";
	done
fi
	
if [ "$platform" = 'Darwin' ]; then 
	mdir='/Applications/Visualware/NQC';
else
	echo "=========================================="
	echo "What directory would you like to install NQCSatellite?";
	if [ -f prevlocation ]; then
        	cdir=`tail -n 1 prevlocation`;
	fi
	echo " to assume $cdir, just hit <enter>";
	read mdir;
	if [ -z "$mdir" ]; then
		if [ -f prevlocation ]; then
        		mdir=`tail -n 1 prevlocation`;
			rm prevlocation;
		else
			mdir=$cdir;
		fi
	fi

	echo "$mdir" > prevlocation;
fi

if [ -f $mdir/nqc.sh ]; then
	echo "Previous install detected, please confirm overwrite (y/n)";
	read mconfirm;
	if [ "$mconfirm" != "y" ]; then
		exit 1;
	fi
	sh $mdir/nqc.sh stop;
fi

if [ ! -d $mdir ]; then
	mkdir -m 775 -p $mdir;
fi

bnam=`basename $mdir`;
cd $mdir;

if [ "$platform" = 'Darwin' ]; then 
	tar -xf $fdir/nqc.tar thisversion osxNQCSatellite;
	check_version;
	cp -f osxNQCSatellite $mdir/NQCSatellite;
	echo "Copy OSX executable live";
elif [ "$platform" = 'Linux' ]; then
	tar -xf $fdir/nqc.tar thisversion nqc_uninstall.sh PartTwo.sh update_nqc.sh;
	check_version;
	if [ "$arch" = "armv6l" ]; then
		tar -xf $fdir/nqc.tar armNQCSatellite;
         	cp -f armNQCSatellite NQCSatellite;
         	echo "Copying Arm executable live";
         elif [ "$arch" = "armv7l" ]; then
		tar -xf $fdir/nqc.tar armNQCSatellite;
         	cp -f armNQCSatellite NQCSatellite;
         	echo "Copying Arm executable live";
         elif [ "$arch" = "armv5tel" ]; then
		tar -xf $fdir/nqc.tar armNQCSatellite;
         	cp -f armNQCSatellite NQCSatellite;
         	echo "Copying Arm executable live";
         elif [ "$arch" = "aarch64" ]; then
		tar -xf $fdir/nqc.tar aarch64NQCSatellite;
         	cp -f aarch64NQCSatellite NQCSatellite;
         	echo "Copying Arm executable live";
         elif [ "$arch" = "x86_64" ]; then
		tar -xf $fdir/nqc.tar x86_64NQCSatellite;
         	cp -f x86_64NQCSatellite NQCSatellite;
         	echo "Copying x86 64bit executable live";
         else
         	echo "Please contact support for a 32 bit NQC executable";
         fi
fi

if [ "$platform" = 'Darwin' ]; then 
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" > $mdir/com.visualware.nqc.plist;
	echo "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">" >> $mdir/com.visualware.nqc.plist;
	echo "<plist version=\"1.0\">" >> $mdir/com.visualware.nqc.plist;
	echo "<dict>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>Label</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<string>com.visualware.nqc</string>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>Program</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<string>/Applications/Visualware/NQC/NQCSatellite</string>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>WorkingDirectory</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<string>/Applications/Visualware/NQC</string>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>ProgramArguments</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<array>" >> $mdir/com.visualware.nqc.plist;
	echo "\t\t<string>/Applications/Visualware/NQC/NQCSatellite</string>" >> $mdir/com.visualware.nqc.plist;
fi

echo "==========================================";
echo "Would you like to configure NQC as a Satellite or as an agent? S or A. Default S";
# add explanation
read satoragent;
if [ -z "$satoragent" ]; then 
	satoragt="S";
 else
	satoragt=$satoragent;
fi

echo "==========================================";
echo "Enter the MCS URL or IP, example mcs.abc.com";
read mcsip;
echo "==========================================";
echo "Enter the MCS Port, enter nothing for default 80";
read port;
if [ -z "$port" ]; then 
	mcsport="80";
 else
	mcsport=$port;
fi

if [ "$satoragt" = 'S' ] || [ "$satoragt" = 's' ]; then
	echo "==========================================";
	echo "Enter Satellite Web port, enter nothing for default 8080, enter 0 for no web interface";
	read swport;
	if [ -z "$swport" ]; then
		satwebport="8080";
 	 else
		satwebport=$swport;
	fi
	echo "==========================================";
	echo "Enter a friendly name to identify the Satellite";
	read uniqname;

	echo "==========================================";
	echo "Is this Satellite being installed on a Virtual Machine (y/n)?";
	read vmachine;

	if [ "$vmachine" = 'Y' ] || [ "$vmachine" = 'y' ]; then
		if [ -f /sbin/ifconfig ]; then
			macaddr=`/sbin/ifconfig eth0 | grep -i hwaddr | awk '{print $5}'`;
		else
			macaddr=`head /dev/urandom | tr -dc A-Z0-9 | head -c12`;
		fi

		if [ ! -z "$uniqname" ]; then
			nqcargs="$mcsip:$mcsport -p$satwebport -u$uniqname -n$macaddr";
			nuniq="-n$macaddr";
	 	else
			nqcargs="$mcsip:$mcsport -p$satwebport -n$macaddr";
			nuniq="-n$macaddr";
		fi
	else
		if [ ! -z "$uniqname" ]; then
			nqcargs="$mcsip:$mcsport -p$satwebport -u$uniqname";
	 	else
			nqcargs="$mcsip:$mcsport -p$satwebport";
		fi
	fi
	if [ "$platform" = 'Darwin' ]; then 
		echo "\t\t<string>$mcsip:$mcsport</string>" >> $mdir/com.visualware.nqc.plist;
		echo "\t\t<string>-p$satwebport</string>" >> $mdir/com.visualware.nqc.plist;
		if [ ! -z "$uniqname" ]; then
			echo "\t\t<string>-u$uniqname</string>" >> $mdir/com.visualware.nqc.plist;
		fi
	fi
 else
	echo "=========================================="
	echo "Enter password, enter nothing for default";
	read passwd;
	if [ -z "$passwd" ]; then
		rapassword=" ";
 	 else
		rapassword=$passwd;
	fi
	echo "=========================================="
	echo "Enter the test name to run";
	read tname;
	if [ -z "$tname" ]; then
		testname="testname-not-set";
 	 else
		testname=$tname;
	fi
	echo "=========================================="
	echo "Enter an ID name to tag the test report";
	read tagname;
	if [ -z "$tagname" ]; then
		idname="idname-not-set";
 	 else
		idname=$tagname;
	fi
	nqcargs="$mcsip:$mcsport $rapassword -a$testname -u$idname -p0";
	if [ "$platform" = 'Darwin' ]; then 
		echo "\t\t<string>$mcsip:$mcsport</string>" >> $mdir/com.visualware.nqc.plist;
		echo "\t\t<string>$rapassword</string>" >> $mdir/com.visualware.nqc.plist;
		echo "\t\t<string>-a$testname</string>" >> $mdir/com.visualware.nqc.plist;
		echo "\t\t<string>-u$idname</string>" >> $mdir/com.visualware.nqc.plist;
		echo "\t\t<string>-p0</string>" >> $mdir/com.visualware.nqc.plist;
	fi
fi

if [ "$platform" = 'Darwin' ]; then 
	echo "\t</array>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>KeepAlive</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<true/>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>RunAtLoad</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<true/>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<key>StandardOutPath</key>" >> $mdir/com.visualware.nqc.plist;
	echo "\t<string>stdout.txt</string>" >> $mdir/com.visualware.nqc.plist;
	echo "</dict>" >> $mdir/com.visualware.nqc.plist;
	echo "</plist>" >> $mdir/com.visualware.nqc.plist;
else
	if [ -f $mdir/start_nqc.sh ]; then 
		rm $mdir/start_nqc.sh;
	fi
	echo "#!/bin/sh" > $mdir/start_nqc.sh;
	echo " " >> $mdir/start_nqc.sh;
	echo ": Make sure we get executed by sh on all systems" >> $mdir/start_nqc.sh;
	echo "sh $mdir/update_nqc.sh start" >> $mdir/start_nqc.sh;
	chmod +x $mdir/start_nqc.sh;

	echo "#!/bin/sh" > $mdir/stop_nqc.sh;
	echo " " >> $mdir/stop_nqc.sh;
	echo ": Make sure we get executed by sh on all systems" >> $mdir/stop_nqc.sh;
	echo "sh $mdir/nqc.sh stop" >> $mdir/stop_nqc.sh;
	chmod +x $mdir/stop_nqc.sh;

	if [ "$initservice" = 'systemd' ]; then 
		echo "[Unit]" > $mdir/visualware_nqc.service;
		echo "Description=Visualware NQC daemon" >> $mdir/visualware_nqc.service;
		echo "After=network.target" >> $mdir/visualware_nqc.service;
		echo " " >> $mdir/visualware_nqc.service;
		echo "[Service]" >> $mdir/visualware_nqc.service;
		echo "Type=forking" >> $mdir/visualware_nqc.service;
		echo "ExecStart=$mdir/visualware_nqc.sh start" >> $mdir/visualware_nqc.service;
		echo "ExecStop=$mdir/visualware_nqc.sh stop" >> $mdir/visualware_nqc.service;
		echo " " >> $mdir/visualware_nqc.service;
		echo "[Install]" >> $mdir/visualware_nqc.service;
		echo "WantedBy=multi-user.target" >> $mdir/visualware_nqc.service;
	fi
		
	echo "#!/bin/sh" > $mdir/visualware_nqc.sh;
	echo "# " >> $mdir/visualware_nqc.sh;
	echo "### BEGIN INIT INFO" >> $mdir/visualware_nqc.sh;
	echo "# Provides:          visualware_nqc" >> $mdir/visualware_nqc.sh;
	echo "# Required-Start:    \$all" >> $mdir/visualware_nqc.sh;
	echo "# Required-Stop:     \$local_fs" >> $mdir/visualware_nqc.sh;
	echo "# Default-Start:     2 3 4 5" >> $mdir/visualware_nqc.sh;
	echo "# Default-Stop:      0 1 6" >> $mdir/visualware_nqc.sh;
	echo "# Short-Description: nqc" >> $mdir/visualware_nqc.sh;
	echo "# Description:       Visualware NQC daemon" >> $mdir/visualware_nqc.sh;
	echo "### END INIT INFO" >> $mdir/visualware_nqc.sh;
	echo "# visualware-nqc	This shell script starts and stops Visualware nqc script" >> $mdir/visualware_nqc.sh;
	echo "# chkconfig: 2345 85 10" >> $mdir/visualware_nqc.sh;
	echo "# description: NQCSatellite can perform connection tests" >> $mdir/visualware_nqc.sh;
 	echo " " >> $mdir/visualware_nqc.sh;
	echo ": Make sure we get executed by sh on all systems" >> $mdir/visualware_nqc.sh;
	echo " " >> $mdir/visualware_nqc.sh;
	echo "case \"\$1\" in" >> $mdir/visualware_nqc.sh;
	echo "'start')" >> $mdir/visualware_nqc.sh;
	echo "		sh $mdir/start_nqc.sh" >> $mdir/visualware_nqc.sh;
        echo "		;;" >> $mdir/visualware_nqc.sh;
	echo "'status')" >> $mdir/visualware_nqc.sh;
        echo "		sh $mdir/nqc.sh status" >> $mdir/visualware_nqc.sh;
        echo "		;;" >> $mdir/visualware_nqc.sh;
	echo "'stop')" >> $mdir/visualware_nqc.sh;
        echo "		sh $mdir/stop_nqc.sh" >> $mdir/visualware_nqc.sh;
        echo "		;;" >> $mdir/visualware_nqc.sh;
	echo "esac" >> $mdir/visualware_nqc.sh;
	chmod +x $mdir/visualware_nqc.sh;

	echo "#!/bin/sh" > $mdir/nqc.sh;
	echo "# " >> $mdir/nqc.sh;
	echo ": Make sure we get executed by sh on all systems" >> $mdir/nqc.sh;
	echo " " >> $mdir/nqc.sh;
	echo "NQCHOME=$mdir" >> $mdir/nqc.sh;
	echo "PATH=${dirnam}:/usr/bin:/bin:$mdir:." >> $mdir/nqc.sh;
	echo "NQCARGS=\"$nqcargs\"" >> $mdir/nqc.sh;
	echo "NUNIQ=\"$nuniq\"" >> $mdir/nqc.sh;
	echo "export NQCHOME PATH NQCARGS NUNIQ" >> $mdir/nqc.sh;
	cat PartTwo.sh >> $mdir/nqc.sh;
	rm PartTwo.sh $fdir/nqc.tar;
	chmod +x $mdir/nqc.sh;
fi

echo "Checking if service exists";
if [ -f /etc/init.d/visualware_nqc ]; then
	rm /etc/init.d/visualware_nqc;
	/usr/sbin/update-rc.d -f visualware_nqc remove;
fi
if [ -f /etc/systemd/system/visualware_nqc.service ]; then
	systemctl stop visualware_nqc;
	systemctl disable visualware_nqc;
	rm $dest/visualware_nqc.service;
fi
if [ -f /etc/init.d/$bnam ]; then
	rm /etc/init.d/$bnam;
	/usr/sbin/update-rc.d -f $bnam remove;
fi
if [ -f /etc/rc.d/init.d/$bnam ]; then
	chkconfig --del $bnam;
fi
if [ -f /etc/rc.d/init.d/visualware_nqc ]; then
	chkconfig --del visualware_nqc;
fi

if [ "$platform" = 'Darwin' ]; then 
	if [ -f /Applications/Visualware/NQC/com.visualware.nqc.plist ]; then
		cp /Applications/Visualware/NQC/com.visualware.nqc.plist /Library/LaunchDaemons;
		launchctl load /Library/LaunchDaemons/com.visualware.nqc.plist;
		echo "nqc copy new plist and call launchctl";
	fi
elif [ "$initservice" = 'systemd' ]; then 
        echo "=========================================="
        echo "Do you want NQCSatellite to automatically run everytime the machine starts y or n?";
        read cservice;
	dest="/etc/systemd/system";
        if [ "$cservice" = "y" ]; then
                cp $mdir/visualware_nqc.service $dest/visualware_nqc.service;
		systemctl enable visualware_nqc;
		systemctl start visualware_nqc;
		echo "Starting Visualware nqc service";
        fi
elif [ -x /usr/sbin/update-rc.d ]; then
        echo "=========================================="
        echo "Do you want NQCSatellite to automatically run everytime the machine starts y or n?";
        read cservice;
        dest="/etc/init.d";
        if [ "$cservice" = "y" ]; then
                cp $mdir/visualware_nqc.sh $dest/visualware_nqc;
                /usr/sbin/update-rc.d visualware_nqc start 90 2 3 4 5 . stop 90 0 1 6 .;
        fi
elif [ -x /sbin/chkconfig ]; then
	echo "=========================================="
	echo "Do you want NQCSatellite to automatically run everytime the machine starts y or n?";
	read cservice;
	if [ -f /etc/debian_version ]; then
		dest="/etc/init.d";
	elif [ -f /etc/SuSE-release ]; then
		dest="/etc/init.d";
	else
		dest="/etc/rc.d/init.d";
	fi
	if [ "$cservice" = "y" ]; then
		cp $mdir/visualware_nqc.sh $dest/visualware_nqc;
		chkconfig --add visualware_nqc;
	fi
fi
echo "=========================================="
echo "Installation complete";
echo "=========================================="

if [ "$platform" != 'Darwin' ] && [ "$initservice" != 'systemd' ]; then 
	echo "Starting Visualware nqc service";
	sh $mdir/start_nqc.sh;
fi
