
arch=`uname -m`;
platform=`uname -s`;

show_messages () {
	if tty -s; then
		echo $1
	fi
	echo "script `date`:- $1" >>$NQCHOME/console.nqc.sh;
}

if id | grep "^uid=0(" >/dev/null 2>&1
	then # user IS superuser
       		show_messages "Commencing NQCSatellite service as root."
	else
       		show_messages "NQCSatellite needs to be run as root.";
       	exit 1;
fi


USAGE="Usage: nqc.sh { start | stop | status } "

stop_process () {
        cd $NQCHOME;

	if [ "$platform" = 'Linux' ]; then
			pslist=`/bin/ps -elf | grep NQCSatellite`
	else
			pslist=`/bin/ps -ef | grep NQCSatellite`
	fi
			
        show_messages "Attempting to stop NQCSatellite service."
	if [ "$platform" = 'Linux' ]; then
        	PID=`echo "$pslist" | grep -v grep | awk '{ print $4 }'`
        else
        	PID=`echo "$pslist" | grep -v grep | awk '{ print $2 }'`
        fi

        if [ ! -z "$PID" ]; then
        	show_messages "Attempting to stop NQCSatellite PID: $PID.";
            	/bin/kill ${PID} > /dev/null 2>&1;
        fi
}

status_process () {
	if [ "$platform" = 'Linux' ]; then
		pslist=`/bin/ps -elf | grep NQCSatellite`
	else
		pslist=`/bin/ps -ef | grep NQCSatellite`
	fi

	show_messages "Checking for running NQCSatellite service."

	if [ "$platform" = 'Linux' ]; then
		PID=`echo "$pslist" | grep -v grep | awk '{ print $4 }'`;
	else
		PID=`echo "$pslist" | grep -v grep | awk '{ print $2 }'`;
	fi

	if [ ! -z "$PID" ]; then
		show_messages "NQCSatellite process running with PID: $PID.";
	else
		show_messages "Unable to detect the NQCSatellite process running.";
		show_messages "Confirm that you have attempted to start it,";
	fi
}

start_process () {
	# Make sure the path is mounted
	if [ ! -f $NQCHOME/NQCSatellite ]; then
        	show_messages "Unable to find the NQCSatellite executable in directory $NQCHOME.";
		show_messages "Please check that NQCHOME is set correctly in this script.";
        	exit;	
	fi

	# If there is a nqc.tar present someone has untared an upgrade but not done a nqc_configure.sh
	if [ -f $NQCHOME/nqc.tar ]; then
        	show_messages "A nqc.tar is present, running configure.";
		sh nqc_configure.sh;
        	exit;
	fi

	cd $NQCHOME;

	if [ -s $NQCHOME/NQCSatellite ]; then
		show_messages "NQCSatellite service starting.";
		if [ -f $NQCHOME/netqcheck.cfg ]; then 
          		NQCSatellite $NUNIQ nogui & 
		else
          		NQCSatellite $NQCARGS nogui & 
		fi
	else
		show_messages "Unable to find or execute NQCSatellite ($1) service.";
	fi
}

# Check arguments started with
if [ "$1" = 'help' ]; then
        show_messages $USAGE;
        exit 1;
fi

cd $NQCHOME;

# Check arguments started with
if [ ! "$1" = 'stop' ] && [ ! "$1" = 'start' ] && [ ! "$1" = 'status' ]; then
	show_messages "Assuming start";
	start_process;
	show_messages "  ";
	show_messages "To stop NQCSatellite, type 'sh $NQCHOME/nqc.sh stop'.";
	show_messages "  ";
    exit 1;
fi

case "$1" in
'start')
	start_process
	;;
'status')
        status_process
        ;;
'stop')
        stop_process
        ;;
*)
        show_messages $USAGE
        ;;
esac
exit 0;
