#!/bin/sh
: Make sure we get executed by sh on all systems

platform=`uname -s`;
echo "=========================================="
if id | grep "^uid=0(" >/dev/null 2>&1
	then # user IS superuser
        	echo "Commencing NQCSatellite uninstall as root.";
	else
        	echo "NQCSatellite needs to be uninstall as root.";
        	exit 1;
fi

cdir=`pwd`;

if [ -f $cdir/nqc.sh ]; then
	sh $cdir/nqc.sh stop;
fi

bnam=`basename $cdir`;
initservice=`ps -p1 | grep systemd | awk '{print $4}'`;
cd $cdir;

dest="/etc/systemd/system";
if [ -f $dest/visualware_nqc.service ]; then
               echo "Removing existing systemd Visualware nqc service";
	systemctl stop visualware_nqc;
	systemctl disable visualware_nqc;
        rm $dest/visualware_nqc.service;
fi
if [ -x /usr/sbin/update-rc.d ]; then
        dest="/etc/init.d";
        if [ -f $dest/$bnam ]; then
                echo "Removing existing init.d $bnam service";
                rm /etc/init.d/$bnam;
                /usr/sbin/update-rc.d -f $bnam remove;
        fi
        if [ -f $dest/visualware_nqc ]; then
                echo "Removing existing init.d visualware_nqc service";
                rm /etc/init.d/visualware_nqc;
                /usr/sbin/update-rc.d -f visualware_nqc remove;
        fi
fi
if [ -x /sbin/chkconfig ]; then
	if [ -f /etc/debian_version ]; then
		dest="/etc/init.d";
	elif [ -f /etc/SuSE-release ]; then
		dest="/etc/init.d";
	else
		dest="/etc/rc.d/init.d";
	fi
	if [ -f $dest/$bnam ]; then
		echo "Removing existing chkconfig $bnam service";
		chkconfig --del $bnam;
		rm $dest/$bnam;
	fi
        if [ -f $dest/visualware_nqc ]; then
                echo "Removing existing chkconfig visualware_nqc service";
                chkconfig --del visualware_nqc;
        fi
fi

if [ -f aarch64NQCSatellite ]; then
	rm aarch64NQCSatellite;
fi
if [ -f armNQCSatellite ]; then
	rm armNQCSatellite;
fi
if [ -f x86NQCSatellite ]; then
	rm x86NQCSatellite;
fi
if [ -f x86_64NQCSatellite ]; then
	rm x86_64NQCSatellite;
fi
if [ -f x86_32NQCSatellite ]; then
	rm x86_32NQCSatellite;
fi
if [ -f NQCSatellite ]; then
	rm NQCSatellite;
fi
if [ -f update_nqc.sh ]; then 
	rm update_nqc.sh;
fi
if [ -f start_nqc.sh ]; then 
	rm start_nqc.sh;
fi
if [ -f stop_nqc.sh ]; then 
	rm stop_nqc.sh;
fi
if [ -f nqc.sh ]; then 
	rm nqc.sh;
fi
if [ -f visualware_nqc.service ]; then 
	rm visualware_nqc.service;
fi
if [ -f visualware_nqc.sh ]; then 
	rm visualware_nqc.sh;
fi
if [ -f nqc_configure.sh ]; then 
	rm nqc_configure.sh;
fi
if [ -f console.log ]; then 
	rm console.log;
fi
if [ -f console.nqc.sh ]; then 
	rm console.nqc.sh;
fi
if [ -f console.update_nqc.sh ]; then 
	rm console.update_nqc.sh;
fi
if [ -f prevlocation ]; then 
	rm prevlocation;
fi
if [ -f thisversion ]; then 
	rm thisversion;
fi
if [ -f wgetnqcsatversion.log ]; then 
	rm wgetnqcsatversion.log;
fi
if [ -f nqcsatversion ]; then 
	rm nqcsatversion;
fi
if [ -f netqcheck.cfg ]; then 
	rm netqcheck.cfg;
fi
echo "=========================================="
echo "NQCSatellite uninstall complete.";
