#!/bin/sh
# 
: Make sure we get executed by sh on all systems
 
cd "`dirname "$0"`";

usage="Usage: update_nqc.sh { start | startonly | stop | updateonly } ";
arch=`uname -m`;
archfnam=`uname -m`NQCSatellite;

show_messages () {
	if tty -s; then
		echo $1
	fi
	echo "script `date`:- $1" >>console.update_nqc.sh;
}
removewgetlogs() {
	if [ -f wgetnqcsatversion.log ]; then
		show_messages "remove wget nqcsatversion log"
		rm wgetnqcsatversion.log;
	fi
	if [ -f wgetnqcsatellite.log ]; then
		show_messages "remove wget nqcsatellite log"
		rm wgetnqcsatellite.log;
	fi
}

update () {
	removewgetlogs;

	serverip='127.0.0.1';
	if [ ! -f nqc.sh ]; then
		show_messages "nqc.sh script not found for update to proceed";
		exit 0;
	else
		serverip=`grep -m 1 NQCARGS nqc.sh | awk '{ print $1}' | sed "s/\"/ /g" | awk '{ print $2 }'`;
		show_messages "nqc.sh script has server ip $serverip";
	fi

	wget http://$serverip/myspeed/nqcsatversion --retry-connrefused -O nqcsatversion -o wgetnqcsatversion.log
	if [ $? -ne 0 ]; then
		show_messages "wget of nqcsatversion file failed";
		return 1;
	fi

	thisversion=0;
	if [ -f thisversion ]; then
		thisversion=`cat thisversion`;
	fi

	serverversion=99999;
	servercksum=0;
	ckarch='cx';
	if [ $arch = "aarch64" ]; then
		ckarch='aa';
	elif [ $arch = "armv6l" ] || [ $arch = "armv7l" ] || [ $arch = "armv5tel" ]; then
		ckarch='ca';
	elif [ $arch = "x86_64" ]; then 
		ckarch='cx';
	else
		ckarch='co';
	fi
	if [ -f nqcsatversion ]; then
		serverversion=`cat nqcsatversion | grep -i v | awk '{print $2}' `;
		servercksum=`cat nqcsatversion | grep -i $ckarch | awk '{print $2}' `;
	fi

	show_messages "arch $arch ckarch $ckarch servercksum $servercksum";

	if [ $serverversion -le $thisversion ]; then
		show_messages "Satellite update version check: MCS server $serverversion, Satellite $thisversion, no update required";
		return 0;
	fi

	show_messages "Get file from server";
	wget http://$serverip/myspeed/$archfnam --retry-connrefused -O $archfnam-new -o wgetnqcsatellite.log;
	if [ $? -ne 0 ]; then
		show_messages "wget of $archfnam file failed";
		return 1;
	fi
	newcksum=0;
	if [ -f $archfnam-new ]; then
		chmod +x $archfnam-new;
		newcksum=`cksum $archfnam-new | awk '{print $1}'`;
		show_messages "checksum of new local file $newcksum";
		if [ $servercksum -eq $newcksum ]; then
			show_messages "Satellite update version check: MCS server $serverversion, Satellite $thisversion, update performed";
			chmod +x $archfnam-new;
			rm -f $archfnam nqcsatversion thisversion;
			mv $archfnam-new NQCSatellite;
			echo $serverversion > thisversion;
		else
			show_messages "Satellite update version check: MCS server $serverversion, Satellite $thisversion, update failed as checksum mismatch";
			rm -f $archfnam-new nqcsatversion;
		fi
	fi

	removewgetlogs;
}

case "$1" in
'start')
        update
	sh nqc.sh start
        ;;
'startonly')
	sh nqc.sh start
        ;;
'stop')
        sh nqc.sh stop
        ;;
'updateonly')
        update
        ;;
*)
        echo $usage
        ;;
esac
exit 0;
